/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.DataReader;
import net.sf.uadetector.internal.data.XmlDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDataReader
implements DataReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDataReader.class);

    @Override
    public Data read(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 'inputStream' must not be null.");
        }
        Data.Builder builder = new Data.Builder();
        try {
            XmlParser.parse(inputStream, builder);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        return builder.build();
    }

    @Override
    public Data read(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.");
        }
        Data.Builder builder = new Data.Builder();
        try {
            XmlParser.parse(url.toExternalForm(), builder);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.warn(e.getLocalizedMessage());
        }
        return builder.build();
    }

    private static final class XmlParser {
        private XmlParser() {
        }

        public static void parse(InputStream stream, Data.Builder builder) throws ParserConfigurationException, SAXException, IOException {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XmlDataHandler handler = new XmlDataHandler(builder);
            parser.parse(stream, (DefaultHandler)handler);
        }

        public static void parse(String uri, Data.Builder builder) throws ParserConfigurationException, SAXException, IOException {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XmlDataHandler handler = new XmlDataHandler(builder);
            parser.parse(uri, (DefaultHandler)handler);
        }
    }
}

