/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.uadetector.internal.data.OrderedPatternComparator;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Data {
    public static final Data EMPTY = new Data(new HashSet<Browser>(), new HashSet<OperatingSystem>(), new HashSet<Robot>(0), new TreeMap<BrowserPattern, Browser>(), new TreeMap<OperatingSystemPattern, OperatingSystem>(), "");
    private final Set<Browser> browsers;
    private final Set<OperatingSystem> operatingSystems;
    private final Set<Robot> robots;
    private final String version;
    private final SortedMap<BrowserPattern, Browser> patternBrowserMap;
    private final SortedMap<OperatingSystemPattern, OperatingSystem> patternOsMap;

    public Data(Set<Browser> browsers, Set<OperatingSystem> operatingSystems, Set<Robot> robots, SortedMap<BrowserPattern, Browser> patternBrowserMap, SortedMap<OperatingSystemPattern, OperatingSystem> patternOsMap, String version) {
        if (browsers == null) {
            throw new IllegalArgumentException("Argument 'browsers' must not be null.");
        }
        if (operatingSystems == null) {
            throw new IllegalArgumentException("Argument 'operatingSystems' must not be null.");
        }
        if (robots == null) {
            throw new IllegalArgumentException("Argument 'robots' must not be null.");
        }
        if (patternBrowserMap == null) {
            throw new IllegalArgumentException("Argument 'patternBrowserMap' must not be null.");
        }
        if (patternOsMap == null) {
            throw new IllegalArgumentException("Argument 'patternOsMap' must not be null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 'version' must not be null.");
        }
        this.browsers = browsers;
        this.operatingSystems = operatingSystems;
        this.patternBrowserMap = patternBrowserMap;
        this.patternOsMap = patternOsMap;
        this.robots = robots;
        this.version = version;
    }

    public Set<Browser> getBrowsers() {
        return Collections.unmodifiableSet(this.browsers);
    }

    public Set<OperatingSystem> getOperatingSystems() {
        return Collections.unmodifiableSet(this.operatingSystems);
    }

    public SortedMap<BrowserPattern, Browser> getPatternBrowserMap() {
        return this.patternBrowserMap;
    }

    public SortedMap<OperatingSystemPattern, OperatingSystem> getPatternOsMap() {
        return this.patternOsMap;
    }

    public Set<Robot> getRobots() {
        return Collections.unmodifiableSet(this.robots);
    }

    public String getVersion() {
        return this.version;
    }

    public String toStats() {
        StringBuilder builder = new StringBuilder();
        builder.append("UAS data stats\n");
        builder.append("----------------------------------------------------------------");
        builder.append('\n');
        builder.append("version:\t\t");
        builder.append(this.version);
        builder.append('\n');
        builder.append("browser:\t\t");
        builder.append(this.browsers.size());
        builder.append('\n');
        HashMap<String, AtomicInteger> browserByType = new HashMap<String, AtomicInteger>();
        for (Browser browser : this.browsers) {
            AtomicInteger counter = (AtomicInteger)browserByType.get(browser.getType().getName());
            if (counter == null) {
                browserByType.put(browser.getType().getName(), new AtomicInteger(1));
                continue;
            }
            counter.incrementAndGet();
        }
        for (Map.Entry entry : browserByType.entrySet()) {
            builder.append('\t');
            builder.append('\t');
            builder.append('\t');
            builder.append((String)entry.getKey());
            builder.append(":\t");
            builder.append(((AtomicInteger)entry.getValue()).get());
            builder.append('\n');
        }
        builder.append("browser patterns:\t");
        builder.append(this.patternBrowserMap.size());
        builder.append('\n');
        builder.append("operating systems:\t");
        builder.append(this.operatingSystems.size());
        builder.append('\n');
        builder.append("os patterns:\t\t");
        builder.append(this.patternOsMap.size());
        builder.append('\n');
        builder.append("robots:\t\t\t");
        builder.append(this.robots.size());
        builder.append('\n');
        builder.append("----------------------------------------------------------------");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Data [browsers=");
        builder.append(this.browsers);
        builder.append(", operatingSystems=");
        builder.append(this.operatingSystems);
        builder.append(", robots=");
        builder.append(this.robots);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", patternBrowserMap=");
        builder.append(this.patternBrowserMap);
        builder.append(", patternOsMap=");
        builder.append(this.patternOsMap);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final Map<Integer, BrowserType> browserTypes = new HashMap<Integer, BrowserType>();
        private final Map<Integer, SortedSet<BrowserPattern>> browserPatterns = new HashMap<Integer, SortedSet<BrowserPattern>>();
        private final Map<Integer, SortedSet<OperatingSystemPattern>> operatingSystemPatterns = new HashMap<Integer, SortedSet<OperatingSystemPattern>>();
        private final Map<Integer, Browser.Builder> browserBuilders = new HashMap<Integer, Browser.Builder>();
        private final Set<Browser> browsers = new HashSet<Browser>();
        private final Map<Integer, OperatingSystem.Builder> operatingSystemBuilders = new HashMap<Integer, OperatingSystem.Builder>();
        private final Set<OperatingSystem> operatingSystems = new HashSet<OperatingSystem>();
        private final Set<Robot> robots = new HashSet<Robot>();
        private String version;
        private final Set<BrowserOperatingSystemMapping> browserOperatingSystemMappings = new HashSet<BrowserOperatingSystemMapping>();
        private static final OrderedPatternComparator<BrowserPattern> BROWSER_PATTERN_COMPARATOR = new OrderedPatternComparator();
        private static final OrderedPatternComparator<OperatingSystemPattern> OS_PATTERN_COMPARATOR = new OrderedPatternComparator();

        private static void addOperatingSystemToBrowser(Map<Integer, Browser.Builder> browserBuilders, Map<Integer, OperatingSystem> operatingSystems, Map<Integer, Integer> browserOsMap) {
            for (Map.Entry<Integer, Integer> entry : browserOsMap.entrySet()) {
                if (browserBuilders.containsKey(entry.getKey())) {
                    Browser.Builder browserBuilder = browserBuilders.get(entry.getKey());
                    if (operatingSystems.containsKey(entry.getValue())) {
                        browserBuilder.setOperatingSystem(operatingSystems.get(entry.getValue()));
                        continue;
                    }
                    LOG.warn("Can not find an operating system with ID '" + entry.getValue() + "' for browser '" + browserBuilder.getProducer() + " " + browserBuilder.getFamily() + "'.");
                    continue;
                }
                LOG.warn("Can not find a browser with ID '" + entry.getKey() + "'.");
            }
        }

        private static void addPatternToBrowser(Map<Integer, Browser.Builder> builders, Map<Integer, SortedSet<BrowserPattern>> patterns) {
            for (Map.Entry<Integer, Browser.Builder> entry : builders.entrySet()) {
                if (patterns.containsKey(entry.getKey())) {
                    entry.getValue().setPatternSet(patterns.get(entry.getKey()));
                    continue;
                }
                LOG.warn("No pattern available for '" + entry.getValue().getProducer() + " " + entry.getValue().getFamily() + "'.");
            }
        }

        private static void addPatternToOperatingSystem(Map<Integer, OperatingSystem.Builder> builders, Map<Integer, SortedSet<OperatingSystemPattern>> patterns) {
            for (Map.Entry<Integer, OperatingSystem.Builder> entry : builders.entrySet()) {
                SortedSet<OperatingSystemPattern> patternSet = patterns.get(entry.getKey());
                if (patternSet != null) {
                    entry.getValue().addPatternSet(patternSet);
                    continue;
                }
                LOG.debug("No patterns for operating system entry (with id '" + entry.getKey() + "') available.");
            }
        }

        private static void addTypeToBrowser(Map<Integer, Browser.Builder> builders, Map<Integer, BrowserType> types) {
            for (Map.Entry<Integer, Browser.Builder> entry : builders.entrySet()) {
                int typeId = entry.getValue().getTypeId();
                if (typeId < 0) continue;
                if (types.containsKey(typeId)) {
                    entry.getValue().setType(types.get(typeId));
                    continue;
                }
                LOG.warn("No type available for '" + entry.getValue().getProducer() + " " + entry.getValue().getFamily() + "'.");
            }
        }

        private static Set<Browser> buildBrowsers(Map<Integer, Browser.Builder> browserBuilders) {
            HashSet<Browser> browsers = new HashSet<Browser>();
            for (Map.Entry<Integer, Browser.Builder> entry : browserBuilders.entrySet()) {
                try {
                    browsers.add(entry.getValue().build());
                }
                catch (Exception e) {
                    LOG.warn("Can not build browser: " + e.getLocalizedMessage());
                }
            }
            return browsers;
        }

        private static Map<Integer, OperatingSystem> buildOperatingSystems(Map<Integer, OperatingSystem.Builder> osBuilders) {
            HashMap<Integer, OperatingSystem> operatingSystems = new HashMap<Integer, OperatingSystem>();
            for (Map.Entry<Integer, OperatingSystem.Builder> entry : osBuilders.entrySet()) {
                try {
                    operatingSystems.put(entry.getKey(), entry.getValue().build());
                }
                catch (Exception e) {
                    LOG.warn("Can not build operating system: " + e.getLocalizedMessage());
                }
            }
            return operatingSystems;
        }

        private static SortedMap<BrowserPattern, Browser> buildPatternBrowserMap(Set<Browser> browserSet) {
            TreeMap<BrowserPattern, Browser> patternBrowser = new TreeMap<BrowserPattern, Browser>(BROWSER_PATTERN_COMPARATOR);
            for (Browser browser : browserSet) {
                for (BrowserPattern pattern : browser.getPatternSet()) {
                    patternBrowser.put(pattern, browser);
                }
            }
            return patternBrowser;
        }

        private static SortedMap<OperatingSystemPattern, OperatingSystem> buildPatternOperatingSystemMap(Set<OperatingSystem> osSet) {
            TreeMap<OperatingSystemPattern, OperatingSystem> map = new TreeMap<OperatingSystemPattern, OperatingSystem>(OS_PATTERN_COMPARATOR);
            for (OperatingSystem os : osSet) {
                for (OperatingSystemPattern pattern : os.getPatternSet()) {
                    map.put(pattern, os);
                }
            }
            return map;
        }

        private static Map<Integer, Integer> convertBrowserOsMapping(Set<BrowserOperatingSystemMapping> browserOperatingSystemMappings) {
            HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
            for (BrowserOperatingSystemMapping mapping : browserOperatingSystemMappings) {
                result.put(mapping.getBrowserId(), mapping.getOperatingSystemId());
            }
            return result;
        }

        private static Set<OperatingSystem> convertOperatingSystems(Map<Integer, OperatingSystem> operatingSystems) {
            HashSet<OperatingSystem> result = new HashSet<OperatingSystem>();
            for (Map.Entry<Integer, OperatingSystem> entry : operatingSystems.entrySet()) {
                result.add(entry.getValue());
            }
            return result;
        }

        public Builder appendBrowser(Browser browser) {
            if (browser == null) {
                throw new IllegalArgumentException("Argument 'browser' must not be null.");
            }
            this.browsers.add(browser);
            return this;
        }

        public Builder appendBrowserBuilder(Browser.Builder browserBuilder) {
            if (browserBuilder == null) {
                throw new IllegalArgumentException("Argument 'browserBuilder' must not be null.");
            }
            if (browserBuilder.getId() < 0) {
                throw new IllegalArgumentException("The ID of argument 'browserBuilder' must not be smaller than 0.");
            }
            if (browserBuilder.getType() == null && browserBuilder.getTypeId() < 0) {
                throw new IllegalArgumentException("A Type or Type-ID of argument 'browserBuilder' must be set.");
            }
            if (this.browserBuilders.containsKey(browserBuilder.getId())) {
                throw new IllegalArgumentException("The browser builder '" + browserBuilder.getProducer() + " " + browserBuilder.getFamily() + "' is already in the map.");
            }
            Browser.Builder builder = browserBuilder.copy();
            this.browserBuilders.put(builder.getId(), builder);
            return this;
        }

        public Builder appendBrowserOperatingSystemMapping(BrowserOperatingSystemMapping browserOsMapping) {
            if (browserOsMapping == null) {
                throw new IllegalArgumentException("Argument 'browserOsMapping' must not be null.");
            }
            this.browserOperatingSystemMappings.add(browserOsMapping);
            return this;
        }

        public Builder appendBrowserPattern(BrowserPattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("Argument 'pattern' must not be null.");
            }
            if (!this.browserPatterns.containsKey(pattern.getId())) {
                this.browserPatterns.put(pattern.getId(), new TreeSet<BrowserPattern>(BROWSER_PATTERN_COMPARATOR));
            }
            this.browserPatterns.get(pattern.getId()).add(pattern);
            return this;
        }

        public Builder appendBrowserType(BrowserType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 'type' must not be null.");
            }
            this.browserTypes.put(type.getId(), type);
            return this;
        }

        public Builder appendOperatingSystem(OperatingSystem operatingSystem) {
            if (operatingSystem == null) {
                throw new IllegalArgumentException("Argument 'operatingSystem' must not be null.");
            }
            this.operatingSystems.add(operatingSystem);
            return this;
        }

        public Builder appendOperatingSystemBuilder(OperatingSystem.Builder operatingSystemBuilder) {
            if (operatingSystemBuilder == null) {
                throw new IllegalArgumentException("Argument 'operatingSystemBuilder' must not be null.");
            }
            if (operatingSystemBuilder.getId() < 0) {
                throw new IllegalArgumentException("The ID of argument 'operatingSystemBuilder' can not be smaller than 0.");
            }
            OperatingSystem.Builder builder = operatingSystemBuilder.copy();
            this.operatingSystemBuilders.put(builder.getId(), builder);
            return this;
        }

        public Builder appendOperatingSystemPattern(OperatingSystemPattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("Argument 'pattern' must not be null.");
            }
            if (!this.operatingSystemPatterns.containsKey(pattern.getId())) {
                this.operatingSystemPatterns.put(pattern.getId(), new TreeSet<OperatingSystemPattern>(OS_PATTERN_COMPARATOR));
            }
            this.operatingSystemPatterns.get(pattern.getId()).add(pattern);
            return this;
        }

        public Builder appendRobot(Robot robot) {
            if (robot == null) {
                throw new IllegalArgumentException("Argument 'robot' must not be null.");
            }
            this.robots.add(robot);
            return this;
        }

        public Data build() {
            Builder.addTypeToBrowser(this.browserBuilders, this.browserTypes);
            Builder.addPatternToBrowser(this.browserBuilders, this.browserPatterns);
            Builder.addPatternToOperatingSystem(this.operatingSystemBuilders, this.operatingSystemPatterns);
            Map<Integer, OperatingSystem> operatingSystems = Builder.buildOperatingSystems(this.operatingSystemBuilders);
            Builder.addOperatingSystemToBrowser(this.browserBuilders, operatingSystems, Builder.convertBrowserOsMapping(this.browserOperatingSystemMappings));
            Set<OperatingSystem> osSet = Builder.convertOperatingSystems(operatingSystems);
            osSet.addAll(this.operatingSystems);
            Set<Browser> browserSet = Builder.buildBrowsers(this.browserBuilders);
            browserSet.addAll(this.browsers);
            SortedMap<BrowserPattern, Browser> patternBrowserMap = Builder.buildPatternBrowserMap(browserSet);
            SortedMap<OperatingSystemPattern, OperatingSystem> patternOsMap = Builder.buildPatternOperatingSystemMap(osSet);
            return new Data(browserSet, osSet, this.robots, patternBrowserMap, patternOsMap, this.version);
        }

        public Builder setVersion(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Argument 'version' must not be null.");
            }
            this.version = version;
            return this;
        }
    }
}

