/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.ReadableOperatingSystem;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.VersionNumber;

public final class UserAgent
implements ReadableUserAgent {
    public static final UserAgent EMPTY = new UserAgent("unknown", "unknown", OperatingSystem.EMPTY, "", "", "", "", VersionNumber.UNKNOWN);
    private final String family;
    private final String name;
    private final OperatingSystem operatingSystem;
    private final String producer;
    private final String producerUrl;
    private final String type;
    private final String url;
    private final VersionNumber versionNumber;

    public UserAgent(String family, String name, OperatingSystem operatingSystem, String producer, String producerUrl, String type, String url, VersionNumber versionNumber) {
        if (family == null) {
            throw new IllegalArgumentException("Argument 'family' must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.");
        }
        if (operatingSystem == null) {
            throw new IllegalArgumentException("Argument 'operatingSystem' must not be null.");
        }
        if (producer == null) {
            throw new IllegalArgumentException("Argument 'producer' must not be null.");
        }
        if (producerUrl == null) {
            throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' must not be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.");
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("Argument 'versionNumber' must not be null.");
        }
        this.family = family;
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.type = type;
        this.url = url;
        this.versionNumber = versionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return this.versionNumber.equals(other.versionNumber);
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public String getProducer() {
        return this.producer;
    }

    @Override
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.operatingSystem.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.versionNumber.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserAgent [family=");
        builder.append(this.family);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", operatingSystem=");
        builder.append(this.operatingSystem);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", versionNumber=");
        builder.append(this.versionNumber);
        builder.append("]");
        return builder.toString();
    }

    static /* synthetic */ String access$000(UserAgent x0) {
        return x0.family;
    }

    static /* synthetic */ String access$100(UserAgent x0) {
        return x0.name;
    }

    static /* synthetic */ String access$200(UserAgent x0) {
        return x0.producer;
    }

    static /* synthetic */ String access$300(UserAgent x0) {
        return x0.producerUrl;
    }

    static /* synthetic */ String access$400(UserAgent x0) {
        return x0.type;
    }

    static /* synthetic */ String access$500(UserAgent x0) {
        return x0.url;
    }

    public static final class Builder
    implements ReadableUserAgent {
        private String family = UserAgent.access$000(EMPTY);
        private String name = UserAgent.access$100(EMPTY);
        private OperatingSystem operatingSystem = OperatingSystem.EMPTY;
        private String producer = UserAgent.access$200(EMPTY);
        private String producerUrl = UserAgent.access$300(EMPTY);
        private String type = UserAgent.access$400(EMPTY);
        private String url = UserAgent.access$500(EMPTY);
        private VersionNumber versionNumber = VersionNumber.UNKNOWN;

        public UserAgent build() {
            return new UserAgent(this.family, this.name, this.operatingSystem, this.producer, this.producerUrl, this.type, this.url, this.versionNumber);
        }

        @Override
        public String getFamily() {
            return this.family;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public String getProducer() {
            return this.producer;
        }

        @Override
        public String getProducerUrl() {
            return this.producerUrl;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public VersionNumber getVersionNumber() {
            return this.versionNumber;
        }

        public Builder setFamily(String family) {
            if (family == null) {
                throw new IllegalArgumentException("Argument 'family' must not be null.");
            }
            this.family = family;
            return this;
        }

        public Builder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 'name' must not be null.");
            }
            this.name = name;
            return this;
        }

        public Builder setOperatingSystem(OperatingSystem operatingSystem) {
            if (operatingSystem == null) {
                throw new IllegalArgumentException("Argument 'operatingSystem' must not be null.");
            }
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder setOperatingSystem(ReadableOperatingSystem os) {
            if (os == null) {
                throw new IllegalArgumentException("Argument 'os' must not be null.");
            }
            this.operatingSystem = new OperatingSystem(os.getFamily(), os.getName(), os.getProducer(), os.getProducerUrl(), os.getUrl());
            return this;
        }

        public Builder setProducer(String producer) {
            if (producer == null) {
                throw new IllegalArgumentException("Argument 'producer' must not be null.");
            }
            this.producer = producer;
            return this;
        }

        public Builder setProducerUrl(String producerUrl) {
            if (producerUrl == null) {
                throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
            }
            this.producerUrl = producerUrl;
            return this;
        }

        public Builder setType(String type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 'type' must not be null.");
            }
            this.type = type;
            return this;
        }

        public Builder setUrl(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Argument 'url' must not be null.");
            }
            this.url = url;
            return this;
        }

        public Builder setVersionNumber(VersionNumber versionNumber) {
            if (versionNumber == null) {
                throw new IllegalArgumentException("Argument 'versionNumber' must not be null.");
            }
            this.versionNumber = versionNumber;
            return this;
        }
    }
}

